/*
 * Decompiled with CFR 0.152.
 */
package com.daehome.app;

import com.daehome.app.MulticastDiscovery;
import com.daehome.model.DeviceTableModel;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main
extends JFrame {
    private final DeviceTableModel tableModel;
    private JScrollPane jScrollPane2;
    private JButton jbExit;
    private JButton jbSearch;
    private JPanel jpDevice;
    private JPanel jpDeviceExplorer;
    private JProgressBar jpbSearch;
    private JTable jtDevice;
    private JTabbedPane jtpContent;

    public Main() {
        this.initComponents();
        ImageIcon imageIcon = new ImageIcon(Main.class.getResource("/META-INF/favicon.png"));
        super.setIconImage(imageIcon.getImage());
        this.tableModel = (DeviceTableModel)this.jtDevice.getModel();
        Dimension dimScreen = super.getToolkit().getScreenSize();
        Dimension dimForm = super.getContentPane().getPreferredSize();
        super.setLocation((dimScreen.width - dimForm.width) / 2, (dimScreen.height - dimForm.height) / 2);
    }

    private void initComponents() {
        this.jtpContent = new JTabbedPane();
        this.jpDeviceExplorer = new JPanel();
        this.jpDevice = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jtDevice = new JTable();
        this.jpbSearch = new JProgressBar();
        this.jbExit = new JButton();
        this.jbSearch = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Device Explorer");
        this.setResizable(false);
        this.jpDeviceExplorer.setRequestFocusEnabled(false);
        this.jpDevice.setBorder(BorderFactory.createTitledBorder("Gateway Device"));
        this.jtDevice.setModel(new DeviceTableModel());
        this.jtDevice.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.jtDeviceMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jtDevice);
        GroupLayout jpDeviceLayout = new GroupLayout(this.jpDevice);
        this.jpDevice.setLayout(jpDeviceLayout);
        jpDeviceLayout.setHorizontalGroup(jpDeviceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDeviceLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 563, Short.MAX_VALUE).addContainerGap()));
        jpDeviceLayout.setVerticalGroup(jpDeviceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpDeviceLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 159, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jbExit.setText("Exit");
        this.jbExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jbExitActionPerformed(evt);
            }
        });
        this.jbSearch.setText("Search");
        this.jbSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jbSearchActionPerformed(evt);
            }
        });
        GroupLayout jpDeviceExplorerLayout = new GroupLayout(this.jpDeviceExplorer);
        this.jpDeviceExplorer.setLayout(jpDeviceExplorerLayout);
        jpDeviceExplorerLayout.setHorizontalGroup(jpDeviceExplorerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpDeviceExplorerLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jbSearch).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jbExit).addGap(12, 12, 12)).addGroup(jpDeviceExplorerLayout.createSequentialGroup().addContainerGap().addGroup(jpDeviceExplorerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jpDevice, -1, -1, Short.MAX_VALUE).addComponent(this.jpbSearch, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jpDeviceExplorerLayout.setVerticalGroup(jpDeviceExplorerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpDeviceExplorerLayout.createSequentialGroup().addContainerGap().addComponent(this.jpDevice, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jpDeviceExplorerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbSearch).addComponent(this.jbExit)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jpbSearch, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jpDevice.getAccessibleContext().setAccessibleName("Gateway Device");
        this.jtpContent.addTab("Device Explorer", this.jpDeviceExplorer);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jtpContent).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jtpContent, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jbExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jtDeviceMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            JTable table = (JTable)evt.getSource();
            int row = table.getSelectedRow();
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(URI.create("http://" + table.getModel().getValueAt(row, 1)));
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void jbSearchActionPerformed(ActionEvent evt) {
        this.jbSearch.setEnabled(false);
        this.jpbSearch.setIndeterminate(true);
        MulticastDiscovery md = new MulticastDiscovery(this.tableModel, this.jbSearch);
        md.addPropertyChangeListener(pce -> {
            if (pce.getPropertyName().equals("progress")) {
                this.jpbSearch.setIndeterminate(false);
                this.jpbSearch.setValue((Integer)pce.getNewValue());
            }
        });
        md.execute();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> new Main().setVisible(true));
    }
}

